/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import net.ftb.data.Settings;
import net.ftb.gui.ChooseDir;
import net.ftb.gui.LaunchFrame;
import net.ftb.locale.I18N;
import net.ftb.log.Logger;
import net.ftb.util.CheckInstallPath;
import net.ftb.util.ErrorUtils;
import net.ftb.util.OSUtils;

public class FirstRunDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final JPanel contentPanel = new JPanel();
    private JTextField installPath;
    private JLabel messageLbl;
    private JLabel installPathLbl;
    private JLabel languageLabel;
    private JButton installPathBrowse;
    private JButton applyButton;
    private JComboBox languageList;

    public FirstRunDialog() {
        super((Frame)LaunchFrame.getInstance(), true);
        this.setupGUI();
        this.getRootPane().setDefaultButton(this.applyButton);
        this.installPathBrowse.addActionListener(new ChooseDir(this));
        this.installPath.setText(OSUtils.getDefInstallPath());
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CheckInstallPath checkResult = new CheckInstallPath(FirstRunDialog.this.installPath.getText());
                if (checkResult.action == CheckInstallPath.Action.BLOCK) {
                    ErrorUtils.tossError(checkResult.message + "\nPlease select again", checkResult.localizedMessage + "\n" + I18N.getLocaleString("CIP_SELECTAGAIN"));
                } else if (checkResult.action == CheckInstallPath.Action.WARN) {
                    ErrorUtils.tossError(checkResult.message + "\nPlease change your installation location under options tab", checkResult.localizedMessage + "\n" + I18N.getLocaleString("CIP_PLEASECHANGE"));
                    FirstRunDialog.this.setVisible(false);
                    Settings.getSettings().setInstallPath(FirstRunDialog.this.installPath.getText());
                    Settings.getSettings().setLocale(I18N.localeIndices.get(FirstRunDialog.this.languageList.getSelectedIndex()));
                    Settings.getSettings().save();
                } else if (checkResult.action == CheckInstallPath.Action.OK) {
                    FirstRunDialog.this.setVisible(false);
                    Settings.getSettings().setInstallPath(FirstRunDialog.this.installPath.getText());
                    Settings.getSettings().setLocale(I18N.localeIndices.get(FirstRunDialog.this.languageList.getSelectedIndex()));
                    Settings.getSettings().save();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupGUI() {
        String[] locales;
        this.setTitle(I18N.getLocaleString("INSTALL_TITLE"));
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/image/logo_ftb.png")));
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(0);
        this.setSize(750, 160);
        this.setLocationRelativeTo(this.getOwner());
        this.setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(null);
        this.messageLbl = new JLabel(I18N.getLocaleString("INSTALL_FIRSTUSE"));
        this.messageLbl.setBounds(5, 5, 729, 20);
        this.messageLbl.setHorizontalAlignment(0);
        this.messageLbl.setFont(this.messageLbl.getFont().deriveFont(1, 16.0f));
        this.contentPanel.add(this.messageLbl);
        this.installPathLbl = new JLabel(I18N.getLocaleString("INSTALL_FOLDER"));
        this.installPathLbl.setBounds(5, 33, 154, 23);
        this.contentPanel.add(this.installPathLbl);
        this.installPathBrowse = new JButton("...");
        this.installPathBrowse.setBounds(679, 36, 55, 23);
        this.contentPanel.add(this.installPathBrowse);
        this.installPath = new JTextField();
        this.installPath.setBounds(169, 33, 500, 23);
        this.contentPanel.add(this.installPath);
        this.installPath.setColumns(10);
        this.languageLabel = new JLabel(I18N.getLocaleString("INSTALL_LANGUAGE"));
        this.languageLabel.setBounds(5, 67, 154, 14);
        this.contentPanel.add(this.languageLabel);
        this.applyButton = new JButton(I18N.getLocaleString("MAIN_APPLY"));
        this.applyButton.setBounds(319, 97, 89, 23);
        this.contentPanel.add(this.applyButton);
        HashMap<Integer, String> hashMap = I18N.localeIndices;
        synchronized (hashMap) {
            locales = new String[I18N.localeIndices.size()];
            for (Map.Entry<Integer, String> entry : I18N.localeIndices.entrySet()) {
                Logger.logInfo("[i18n] Added " + entry.getKey().toString() + " " + entry.getValue() + " to options pane");
                locales[entry.getKey().intValue()] = I18N.localeFiles.get(entry.getValue());
            }
        }
        this.languageList = new JComboBox<String>(locales);
        this.languageList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                I18N.setLocale(I18N.localeIndices.get(FirstRunDialog.this.languageList.getSelectedIndex()));
                if (LaunchFrame.getInstance() != null) {
                    LaunchFrame.getInstance().updateLocale();
                }
                FirstRunDialog.this.updateLocale();
            }
        });
        this.languageList.setSelectedItem(I18N.localeFiles.get(Settings.getSettings().getLocale()));
        this.languageList.setBounds(169, 63, 500, 23);
        this.contentPanel.add(this.languageList);
    }

    public void setInstallFolderText(String text) {
        this.installPath.setText(text);
    }

    private void updateLocale() {
        this.setTitle(I18N.getLocaleString("INSTALL_TITLE"));
        this.messageLbl.setText(I18N.getLocaleString("INSTALL_FIRSTUSE"));
        this.installPathLbl.setText(I18N.getLocaleString("INSTALL_FOLDER"));
        this.applyButton.setText(I18N.getLocaleString("MAIN_APPLY"));
        this.languageLabel.setText(I18N.getLocaleString("INSTALL_LANGUAGE"));
        this.repaint();
    }
}

